#include <windows.h>
#include <stdio.h>

#include "extern.h"



/*
0 = cuts quiet data, creates overflows
40+ = voice data cut @ 11050
*/

#define LIMIT_HEAVY 30



// 6+ = undecided, 5 pushes boundary
#define LIMIT_RANGE 4


// ####################################################
// ####################################################
// ####################################################


/*
Noise 1 - basic static burst (2-point zero peak)
- seems safe to remove at large distant ranges (100+)

- 50 seems close enough to count as 'speech'
  up-(puh), laugh (highs), slur, raspy, breath, cough, snick, A-Ad Avis, emphasis, serious
*/

#define ZERO_SCAN1 100



static BOOL Check_Noise1_16()
{
	INT diff;
	BOOL found;


	found = FALSE;
	for( UINT ptr = 0; ptr < header.dwDataSize; ptr++ )
	{
		// 00 00 .. 00 7F FF 00 00 00 .. 00
		if( buf[ptr-1] >= 0x01 && buf[ptr-1] <= 0x7F &&
				buf[ptr-0] >= 0x81 && buf[ptr-0] <= 0xFF &&
				( buf[ptr-1] & 0x7F ) == ( buf[ptr-0] & 0x7F ) )
		{}


		// 00 00 .. 00 7F FF 00 00 00 .. 00
		else if( buf[ptr-1] >= 0x81 && buf[ptr-1] <= 0xFF &&
						 buf[ptr-0] >= 0x01 && buf[ptr-0] <= 0x7F &&
						 ( buf[ptr-1] & 0x7F ) == ( buf[ptr-0] & 0x7F ) )
		{}


		else
			continue;


		// ##################################################
		// ##################################################
		// ##################################################

		INT pre_zero, post_zero;

		

		pre_zero = 0;
		post_zero = 0;



		// pre-zero
		for( INT lcv = (INT) ptr - 2; lcv >= 0; lcv-- )
		{
			if( buf[ lcv ] != 0x00 &&
					buf[ lcv ] != 0x80 )
				break;


			pre_zero++;
		}


		if( pre_zero < ZERO_SCAN1 )
			continue;



		// post-zero
		for( lcv = (INT) ptr + 1; lcv < (INT) header.dwDataSize; lcv++ )
		{
			if( buf[ lcv ] != 0x00 &&
					buf[ lcv ] != 0x80 )
				break;


			post_zero++;
		}



		if( post_zero < ZERO_SCAN1 )
			continue;


		// ##################################################
		// ##################################################
		// ##################################################

		// save value
		diff = buf[ ptr-0 ] & 0x7F;



		// remove noise
		buf[ ptr-1 ] = 0;
		buf[ ptr-0 ] = 0;


		noise_count++;
		fix_noise = TRUE;
		found = TRUE;



		//if( dpcm_ver == 1 && write_file == FALSE && diff > 5 )
		if( write_file == FALSE && diff > 5 )
		{
			fprintf( fp_log, "Audio %d  (@%07X.001)  //  Noise %d\n", wave_num, wave_num, noise_count );

			fprintf( fp_log, "[%08X - %08X, %08X] 16-bit noise (L) = %d - %X - %d\n",
				start, start + (header.bShift+2) + ptr, (header.bShift+2) + ptr - 1,
				pre_zero, diff, post_zero );


			fprintf( fp_log, "\n" );
			fprintf( fp_log, "\n" );
		}
	}


	return found;
}


// ###############################################################
// ###############################################################
// ###############################################################


// Noise 2 - small noise blocks  (okay)
#define ZERO_PRE_SCAN2 50
#define ZERO_POST_SCAN2 50

#define NONZERO_LOW2 1
#define NONZERO_LIMIT2 100




static BOOL Check_Noise2_16( int range )
{
	int stage;
	int pre_zero;
	int non_zero;
	int post_zero;
	int loc;
	int noisy_data, heavy_noisy;
	BOOL found;


	found = FALSE;
	stage = 1;


	// search for noise blocks
	for( UINT lcv = 0; lcv < header.dwDataSize; lcv++ )
	{
		// check for isolated data - pre-padding
		if( stage == 1 )
		{
			// ignore quiet noise
			if( ( buf[lcv] >= 0x00 && buf[lcv] <= 0x00 + range ) || 
					( buf[lcv] >= 0x80 && buf[lcv] <= 0x80 + range ) )
				continue;


			// ##################################################
			// ##################################################
			// ##################################################

			pre_zero = 0;
			for( int lcv2 = lcv - 1; lcv2 >= 0; lcv2-- )
			{
				// non-quiet noise
				if( ( buf[lcv2] >= 0x00 + range + 1 && buf[lcv2] <= 0x7F ) || 
						( buf[lcv2] >= 0x80 + range + 1 && buf[lcv2] <= 0xFF ) )
					break;


				pre_zero++;
			}


			// ##################################################
			// ##################################################
			// ##################################################

			// not enough - treat as data
			if( pre_zero < ZERO_PRE_SCAN2 )
				continue;




			// data okay
			loc = lcv;
			non_zero = 1;
			noisy_data = 1;
			heavy_noisy = 0;


			if( ( buf[lcv] >= 0x30 && buf[lcv] <= 0x7F ) || 
					( buf[lcv] >= 0xB0 && buf[lcv] <= 0xFF ) )
				heavy_noisy++;



			stage = 2;
		}

		// check for isolated data - post-padding
		else if( stage == 2 )
		{
			// noise data
			if( ( buf[lcv] >= 0x00 + range + 1 && buf[lcv] <= 0x7F ) || 
					( buf[lcv] >= 0x80 + range + 1 && buf[lcv] <= 0xFF ) )
			{
				noisy_data++;
				non_zero++;


				if( ( buf[lcv] >= 0x30 && buf[lcv] <= 0x7F ) || 
						( buf[lcv] >= 0xB0 && buf[lcv] <= 0xFF ) )
					heavy_noisy++;



				// stop at data end
				if( lcv < header.dwDataSize - 1 )
					continue;
			}



			// quiet noise detected - check size limits
			if( lcv < header.dwDataSize - 1 )
			{
				if(	non_zero < NONZERO_LOW2 )
				{
					stage = 1;
					continue;
				}
			}


			// ##################################################
			// ##################################################
			// ##################################################

			post_zero = 0;
			for( UINT lcv2 = lcv; lcv2 < header.dwDataSize; lcv2++ )
			{
				// distance to next noise block
				if( ( buf[lcv2] >= 0x00 + range + 1 && buf[lcv2] <= 0x7F ) || 
						( buf[lcv2] >= 0x80 + range + 1 && buf[lcv2] <= 0xFF ) )
					break;


				post_zero++;
			}



			// not end noise
			if( lcv2 < header.dwDataSize )
			{
				// not enough - treat as noise data
				if( post_zero < ZERO_POST_SCAN2 )
				{
					non_zero++;
					continue;
				}
			}


			// ##################################################
			// ##################################################
			// ##################################################

			stage = 1;



			// discard bad cases
			if( pre_zero < non_zero &&
					post_zero < non_zero )
				continue;


			if( non_zero >= NONZERO_LIMIT2 )
				continue;

				
			if( heavy_noisy == 0 )
				continue;

			if( heavy_noisy >= LIMIT_HEAVY )
				continue;




			// update ptr
			lcv = lcv2 - 1;



			fix_noise = TRUE;
			found = TRUE;


			for( lcv2 = loc; lcv2 < (UINT) loc + non_zero; lcv2++ )
				buf[lcv2] = 0;




			noise_count++;
			if( heavy_noisy > 0 && write_file == FALSE )
			{
				fprintf( fp_log, "Audio %d  (@%07X.001)  //  Noise %d\n", wave_num, wave_num, noise_count );



				fprintf( fp_log, "[%08X - %08X - %08X, %X] 16-bit noise (L) = %d - %d / %d / %d (%X) - %d\n",
					start, start + (header.bShift+2) + loc, start + (header.bShift+2) + loc + non_zero, (header.bShift+2) + loc,
					pre_zero, heavy_noisy, noisy_data, non_zero, non_zero, post_zero );


				fprintf( fp_log, "\n" );
				fprintf( fp_log, "\n" );
			}
		}
	}


	return found;
}


// ###############################################################
// ###############################################################
// ###############################################################


// Noise 3 - zero-pad noise blocks  (okay)
#define ZERO_PRE_SCAN3 50
#define ZERO_POST_SCAN3 50

#define NONZERO_LOW3 1
#define NONZERO_LIMIT3 100




static BOOL Check_Noise3_16( int range )
{
	int stage;
	int pre_zero;
	int non_zero;
	int post_zero;
	int loc;
	int noisy_data, heavy_noisy;
	BOOL found;


	found = FALSE;
	stage = 1;


	// search for noise blocks
	for( UINT lcv = 0; lcv < header.dwDataSize; lcv++ )
	{
		// look for non-zero
		if( stage == 1 )
		{
			// straight silent only
			if( ( buf[lcv] >= 0x00 && buf[lcv] <= 0x00 + range ) || 
					( buf[lcv] >= 0x80 && buf[lcv] <= 0x80 + range ) )
				continue;


			// ##################################################
			// ##################################################
			// ##################################################

			pre_zero = 0;
			for( int lcv2 = lcv - 1; lcv2 >= 0; lcv2-- )
			{
				// non-quiet noise
				if( ( buf[lcv2] >= 0x00 + range + 1 && buf[lcv2] <= 0x7F ) || 
						( buf[lcv2] >= 0x80 + range + 1 && buf[lcv2] <= 0xFF ) )
					break;


				pre_zero++;
			}


			// ##################################################
			// ##################################################
			// ##################################################

			// not enough - treat as data
			if( pre_zero < ZERO_PRE_SCAN3 )
				continue;




			// data okay
			loc = lcv;
			non_zero = 1;
			noisy_data = 1;
			heavy_noisy = 0;


			if( ( buf[lcv] >= 0x30 && buf[lcv] <= 0x7F ) || 
					( buf[lcv] >= 0xB0 && buf[lcv] <= 0xFF ) )
				heavy_noisy++;



			stage = 2;
		}

		else if( stage == 2 )
		{
			// noise data
			if( ( buf[lcv] >= 0x00 + range + 1 && buf[lcv] <= 0x7F ) || 
					( buf[lcv] >= 0x80 + range + 1 && buf[lcv] <= 0xFF ) )
			{
				noisy_data++;
				non_zero++;

					
				if( ( buf[lcv] >= 0x30 && buf[lcv] <= 0x7F ) || 
						( buf[lcv] >= 0xB0 && buf[lcv] <= 0xFF ) )
					heavy_noisy++;




				// not data end
				if( lcv < header.dwDataSize - 1 )
					continue;
			}



			// quiet noise detected - check size limits
			if( lcv < header.dwDataSize - 1 )
			{
				if(	non_zero < NONZERO_LOW3 )
				{
					stage = 1;
					continue;
				}
			}


			// ##################################################
			// ##################################################
			// ##################################################

			post_zero = 0;
			for( UINT lcv2 = lcv; lcv2 < header.dwDataSize; lcv2++ )
			{
				// start of next noise
				if( ( buf[lcv2] >= 0x00 + range + 1 && buf[lcv2] <= 0x7F ) || 
						( buf[lcv2] >= 0x80 + range + 1 && buf[lcv2] <= 0xFF ) )
					break;


				post_zero++;
			}



			// end noise - allow removal
			if( lcv2 < header.dwDataSize )
			{
				// not enough - treat as noise
				if( post_zero < ZERO_POST_SCAN3 )
				{
					non_zero++;
					continue;
				}
			}


			// ##################################################
			// ##################################################
			// ##################################################

			stage = 1;



			// discard bad cases
			if( pre_zero < non_zero &&
					post_zero < non_zero )
				continue;


			if( non_zero >= NONZERO_LIMIT3 )
				continue;


			if( heavy_noisy == 0 )
				continue;

			if( heavy_noisy >= LIMIT_HEAVY )
				continue;



			// update ptr
			lcv = lcv2 - 1;



			fix_noise = TRUE;
			found = TRUE;


			for( lcv2 = loc; lcv2 < (UINT) loc + non_zero; lcv2++ )
				buf[lcv2] = 0;




			noise_count++;
			if( heavy_noisy > 0 && write_file == FALSE )
			{
				fprintf( fp_log, "Audio %d  (@%07X.001)  //  Noise %d\n", wave_num, wave_num, noise_count );



				fprintf( fp_log, "[%08X - %08X - %08X, %X] 16-bit noise (L) = %d - %d / %d / %d (%X) - %d\n",
					start, start + (header.bShift+2) + loc, start + (header.bShift+2) + loc + non_zero, (header.bShift+2) + loc,
					pre_zero, heavy_noisy, noisy_data, non_zero, non_zero, post_zero );


				fprintf( fp_log, "\n" );
				fprintf( fp_log, "\n" );
			}
		}
	}


	return found;
}


// ###############################################################
// ###############################################################
// ###############################################################


// Noise 4 - zero-pad noise blocks  (okay)
#define ZERO_PRE_SCAN4 75
#define ZERO_POST_SCAN4 75

#define NONZERO_LOW4 1
#define NONZERO_LIMIT4 500





static BOOL Check_Noise4_16( int range )
{
	int stage;
	int pre_zero;
	int non_zero;
	int post_zero;
	int loc;
	int noisy_data, heavy_noisy;
	BOOL found;



	found = FALSE;
	stage = 1;



	// search for noise blocks
	for( UINT lcv = 0; lcv < header.dwDataSize; lcv++ )
	{
		// look for non-zero
		if( stage == 1 )
		{
			// straight silent only
			if( ( buf[lcv] >= 0x00 && buf[lcv] <= 0x00 + range ) || 
					( buf[lcv] >= 0x80 && buf[lcv] <= 0x80 + range ) )
				continue;


			// ##################################################
			// ##################################################
			// ##################################################

			pre_zero = 0;
			for( int lcv2 = lcv - 1; lcv2 >= 0; lcv2-- )
			{
				// non-quiet noise
				if( ( buf[lcv2] >= 0x00 + range + 1 && buf[lcv2] <= 0x7F ) || 
						( buf[lcv2] >= 0x80 + range + 1 && buf[lcv2] <= 0xFF ) )
					break;


				pre_zero++;
			}


			// ##################################################
			// ##################################################
			// ##################################################

			// not enough - treat as data
			if( pre_zero < ZERO_PRE_SCAN4 )
				continue;




			// data okay
			loc = lcv;
			non_zero = 1;
			noisy_data = 1;
			heavy_noisy = 0;


			if( ( buf[lcv] >= 0x30 && buf[lcv] <= 0x7F ) || 
					( buf[lcv] >= 0xB0 && buf[lcv] <= 0xFF ) )
				heavy_noisy++;



			stage = 2;
		}

		else if( stage == 2 )
		{
			// noise data
			if( ( buf[lcv] >= 0x00 + range + 1 && buf[lcv] <= 0x7F ) || 
					( buf[lcv] >= 0x80 + range + 1 && buf[lcv] <= 0xFF ) )
			{
				noisy_data++;
				non_zero++;


				if( ( buf[lcv] >= 0x30 && buf[lcv] <= 0x7F ) || 
						( buf[lcv] >= 0xB0 && buf[lcv] <= 0xFF ) )
					heavy_noisy++;




				// not data end
				if( lcv < header.dwDataSize - 1 )
					continue;
			}



			// quiet noise detected - check size limits
			if( lcv < header.dwDataSize - 1 )
			{
				if(	non_zero < NONZERO_LOW4 )
				{
					stage = 1;
					continue;
				}
			}


			// ##################################################
			// ##################################################
			// ##################################################

			post_zero = 0;
			for( UINT lcv2 = lcv; lcv2 < header.dwDataSize; lcv2++ )
			{
				// start of next noise
				if( ( buf[lcv2] >= 0x00 + range + 1 && buf[lcv2] <= 0x7F ) || 
						( buf[lcv2] >= 0x80 + range + 1 && buf[lcv2] <= 0xFF ) )
					break;


				post_zero++;
			}





			// end noise - allow removal
			if( lcv2 < header.dwDataSize )
			{
				// not enough - treat as noise
				if( post_zero < ZERO_POST_SCAN4 )
				{
					// real noise
					if( ( buf[lcv] >= 0x00 + range + 1 && buf[lcv] <= 0x7F ) || 
							( buf[lcv] >= 0x80 + range + 1 && buf[lcv] <= 0xFF ) )
						noisy_data++;


					if( ( buf[lcv] >= 0x20 && buf[lcv] <= 0x7F ) || 
							( buf[lcv] >= 0xA0 && buf[lcv] <= 0xFF ) )
						heavy_noisy++;


					non_zero++;
					continue;
				}
			}


			// ##################################################
			// ##################################################
			// ##################################################

			stage = 1;



			// discard bad cases
			if( pre_zero < non_zero &&
					post_zero < non_zero )
				continue;


			if( non_zero >= NONZERO_LIMIT4 )
				continue;



			if( heavy_noisy == 0 )
				continue;

			if( heavy_noisy >= LIMIT_HEAVY )
				continue;



			// update ptr
			lcv = lcv2 - 1;



			fix_noise = TRUE;
			found = TRUE;

			for( lcv2 = loc; lcv2 < (UINT) loc + non_zero; lcv2++ )
				buf[lcv2] = 0;




			noise_count++;


			if( heavy_noisy > 0 && write_file == FALSE )
			{
				fprintf( fp_log, "Audio %d  (@%07X.001)  //  Noise %d\n", wave_num, wave_num, noise_count );



				fprintf( fp_log, "[%08X - %08X - %08X, %X] 16-bit noise (L) = %d - %d / %d / %d (%X) - %d\n",
					start, start + (header.bShift+2) + loc, start + (header.bShift+2) + loc + non_zero, (header.bShift+2) + loc,
					pre_zero, heavy_noisy, noisy_data, non_zero, non_zero, post_zero );


				fprintf( fp_log, "\n" );
				fprintf( fp_log, "\n" );
			}
		}
	}


	return found;
}


// #########################################################
// #########################################################
// #########################################################


// Noise 5 - short noise blocks

/*
Detect isolated bursts of static - distant range, small blocks
- Seems safe at pretty far distance, low data limit
*/


#define ZERO_PRE_SCAN5 200
#define ZERO_POST_SCAN5 200

#define NONZERO_LOW5 1
#define NONZERO_LIMIT5 10





static BOOL Check_Noise5_16( int range )
{
	int stage;
	int pre_zero;
	int non_zero;
	int post_zero;
	int loc;
	int noisy_data, heavy_noisy;
	BOOL found;



	found = FALSE;
	stage = 1;



	// search for noise blocks
	for( UINT lcv = 0; lcv < header.dwDataSize; lcv++ )
	{
		// look for non-zero
		if( stage == 1 )
		{
			// straight silent only
			if( ( buf[lcv] >= 0x00 && buf[lcv] <= 0x00 + range ) || 
					( buf[lcv] >= 0x80 && buf[lcv] <= 0x80 + range ) )
				continue;


			// ##################################################
			// ##################################################
			// ##################################################

			pre_zero = 0;
			for( int lcv2 = lcv - 1; lcv2 >= 0; lcv2-- )
			{
				// non-quiet noise
				if( ( buf[lcv2] >= 0x00 + range + 1 && buf[lcv2] <= 0x7F ) || 
						( buf[lcv2] >= 0x80 + range + 1 && buf[lcv2] <= 0xFF ) )
					break;


				pre_zero++;
			}


			// ##################################################
			// ##################################################
			// ##################################################

			// not enough - treat as data
			if( pre_zero < ZERO_PRE_SCAN5 )
				continue;




			// data okay
			loc = lcv;
			non_zero = 1;
			noisy_data = 1;
			heavy_noisy = 0;


			if( ( buf[lcv] >= 0x30 && buf[lcv] <= 0x7F ) || 
					( buf[lcv] >= 0xB0 && buf[lcv] <= 0xFF ) )
				heavy_noisy++;



			stage = 2;
		}

		else if( stage == 2 )
		{
			// noise data
			if( ( buf[lcv] >= 0x00 + range + 1 && buf[lcv] <= 0x7F ) || 
					( buf[lcv] >= 0x80 + range + 1 && buf[lcv] <= 0xFF ) )
			{
				noisy_data++;
				non_zero++;


				if( ( buf[lcv] >= 0x30 && buf[lcv] <= 0x7F ) || 
						( buf[lcv] >= 0xB0 && buf[lcv] <= 0xFF ) )
					heavy_noisy++;




				// not data end
				if( lcv < header.dwDataSize - 1 )
					continue;
			}



			// quiet noise detected - check size limits
			if( lcv < header.dwDataSize - 1 )
			{
				if(	non_zero < NONZERO_LOW5 )
				{
					stage = 1;
					continue;
				}
			}


			// ##################################################
			// ##################################################
			// ##################################################

			post_zero = 0;
			for( UINT lcv2 = lcv; lcv2 < header.dwDataSize; lcv2++ )
			{
				// start of next noise
				if( ( buf[lcv2] >= 0x00 + range + 1 && buf[lcv2] <= 0x7F ) || 
						( buf[lcv2] >= 0x80 + range + 1 && buf[lcv2] <= 0xFF ) )
					break;


				post_zero++;
			}





			// end noise - allow removal
			if( lcv2 < header.dwDataSize )
			{
				// not enough - treat as noise
				if( post_zero < ZERO_POST_SCAN5 )
				{
					// real noise
					if( ( buf[lcv] >= 0x00 + range + 1 && buf[lcv] <= 0x7F ) || 
							( buf[lcv] >= 0x80 + range + 1 && buf[lcv] <= 0xFF ) )
						noisy_data++;


					if( ( buf[lcv] >= 0x20 && buf[lcv] <= 0x7F ) || 
							( buf[lcv] >= 0xA0 && buf[lcv] <= 0xFF ) )
						heavy_noisy++;


					non_zero++;
					continue;
				}
			}


			// ##################################################
			// ##################################################
			// ##################################################

			stage = 1;



			// discard bad cases
			if( pre_zero < non_zero &&
					post_zero < non_zero )
				continue;


			if( non_zero >= NONZERO_LIMIT5 )
				continue;



			if( heavy_noisy == 0 )
				continue;

			if( heavy_noisy >= LIMIT_HEAVY )
				continue;



			// update ptr
			lcv = lcv2 - 1;



			fix_noise = TRUE;
			found = TRUE;

			for( lcv2 = loc; lcv2 < (UINT) loc + non_zero; lcv2++ )
				buf[lcv2] = 0;




			noise_count++;


			if( heavy_noisy > 0 && write_file == FALSE )
			{
				fprintf( fp_log, "Audio %d  (@%07X.001)  //  Noise %d\n", wave_num, wave_num, noise_count );



				fprintf( fp_log, "[%08X - %08X - %08X, %X] 16-bit noise (L) = %d - %d / %d / %d (%X) - %d\n",
					start, start + (header.bShift+2) + loc, start + (header.bShift+2) + loc + non_zero, (header.bShift+2) + loc,
					pre_zero, heavy_noisy, noisy_data, non_zero, non_zero, post_zero );


				fprintf( fp_log, "\n" );
				fprintf( fp_log, "\n" );
			}
		}
	}


	return found;
}


// #########################################################
// #########################################################
// #########################################################

// Noise 6 - short noise blocks

/*
Detect isolated bursts of static - distant range, small blocks
- Seems safe at very far distance, low data limit
*/


#define ZERO_PRE_SCAN6 300
#define ZERO_POST_SCAN6 300

#define NONZERO_LOW6 1
#define NONZERO_LIMIT6 20





static BOOL Check_Noise6_16( int range )
{
	int stage;
	int pre_zero;
	int non_zero;
	int post_zero;
	int loc;
	int noisy_data, heavy_noisy;
	BOOL found;



	found = FALSE;
	stage = 1;



	// search for noise blocks
	for( UINT lcv = 0; lcv < header.dwDataSize; lcv++ )
	{
		// look for non-zero
		if( stage == 1 )
		{
			// straight silent only
			if( ( buf[lcv] >= 0x00 && buf[lcv] <= 0x00 + range ) || 
					( buf[lcv] >= 0x80 && buf[lcv] <= 0x80 + range ) )
				continue;


			// ##################################################
			// ##################################################
			// ##################################################

			pre_zero = 0;
			for( int lcv2 = lcv - 1; lcv2 >= 0; lcv2-- )
			{
				// non-quiet noise
				if( ( buf[lcv2] >= 0x00 + range + 1 && buf[lcv2] <= 0x7F ) || 
						( buf[lcv2] >= 0x80 + range + 1 && buf[lcv2] <= 0xFF ) )
					break;


				pre_zero++;
			}


			// ##################################################
			// ##################################################
			// ##################################################

			// not enough - treat as data
			if( pre_zero < ZERO_PRE_SCAN6 )
				continue;




			// data okay
			loc = lcv;
			non_zero = 1;
			noisy_data = 1;
			heavy_noisy = 0;


			if( ( buf[lcv] >= 0x30 && buf[lcv] <= 0x7F ) || 
					( buf[lcv] >= 0xB0 && buf[lcv] <= 0xFF ) )
				heavy_noisy++;



			stage = 2;
		}

		else if( stage == 2 )
		{
			// noise data
			if( ( buf[lcv] >= 0x00 + range + 1 && buf[lcv] <= 0x7F ) || 
					( buf[lcv] >= 0x80 + range + 1 && buf[lcv] <= 0xFF ) )
			{
				noisy_data++;
				non_zero++;


				if( ( buf[lcv] >= 0x30 && buf[lcv] <= 0x7F ) || 
						( buf[lcv] >= 0xB0 && buf[lcv] <= 0xFF ) )
					heavy_noisy++;




				// not data end
				if( lcv < header.dwDataSize - 1 )
					continue;
			}



			// quiet noise detected - check size limits
			if( lcv < header.dwDataSize - 1 )
			{
				if(	non_zero < NONZERO_LOW6 )
				{
					stage = 1;
					continue;
				}
			}


			// ##################################################
			// ##################################################
			// ##################################################

			post_zero = 0;
			for( UINT lcv2 = lcv; lcv2 < header.dwDataSize; lcv2++ )
			{
				// start of next noise
				if( ( buf[lcv2] >= 0x00 + range + 1 && buf[lcv2] <= 0x7F ) || 
						( buf[lcv2] >= 0x80 + range + 1 && buf[lcv2] <= 0xFF ) )
					break;


				post_zero++;
			}





			// end noise - allow removal
			if( lcv2 < header.dwDataSize )
			{
				// not enough - treat as noise
				if( post_zero < ZERO_POST_SCAN6 )
				{
					// real noise
					if( ( buf[lcv] >= 0x00 + range + 1 && buf[lcv] <= 0x7F ) || 
							( buf[lcv] >= 0x80 + range + 1 && buf[lcv] <= 0xFF ) )
						noisy_data++;


					if( ( buf[lcv] >= 0x20 && buf[lcv] <= 0x7F ) || 
							( buf[lcv] >= 0xA0 && buf[lcv] <= 0xFF ) )
						heavy_noisy++;


					non_zero++;
					continue;
				}
			}


			// ##################################################
			// ##################################################
			// ##################################################

			stage = 1;



			// discard bad cases
			if( pre_zero < non_zero &&
					post_zero < non_zero )
				continue;


			if( non_zero >= NONZERO_LIMIT6 )
				continue;



			if( heavy_noisy == 0 )
				continue;

			if( heavy_noisy >= LIMIT_HEAVY )
				continue;



			// update ptr
			lcv = lcv2 - 1;



			fix_noise = TRUE;
			found = TRUE;

			for( lcv2 = loc; lcv2 < (UINT) loc + non_zero; lcv2++ )
				buf[lcv2] = 0;




			noise_count++;


			if( heavy_noisy > 0 && write_file == FALSE )
			{
				fprintf( fp_log, "Audio %d  (@%07X.001)  //  Noise %d\n", wave_num, wave_num, noise_count );



				fprintf( fp_log, "[%08X - %08X - %08X, %X] 16-bit noise (L) = %d - %d / %d / %d (%X) - %d\n",
					start, start + (header.bShift+2) + loc, start + (header.bShift+2) + loc + non_zero, (header.bShift+2) + loc,
					pre_zero, heavy_noisy, noisy_data, non_zero, non_zero, post_zero );


				fprintf( fp_log, "\n" );
				fprintf( fp_log, "\n" );
			}
		}
	}


	return found;
}


// #########################################################
// #########################################################
// #########################################################

VOID Check_Noise()
{
	BOOL found;


	if( use16 > 0 )
	{
		switch( dpcm_ver )
		{
			case 1: Check_Noise1_16(); break;
			case 2: Check_Noise2_16( LIMIT_RANGE ); break;
			case 3: Check_Noise3_16( LIMIT_RANGE ); break;
			case 4: Check_Noise4_16( LIMIT_RANGE ); break;
			case 5: Check_Noise5_16( LIMIT_RANGE ); break;
			case 6: Check_Noise6_16( LIMIT_RANGE ); break;


			// Noise cleaning
			case 899:
				do
				{
					found = FALSE;



					// big -> small blocks
					found |= Check_Noise6_16( LIMIT_RANGE );
					found |= Check_Noise5_16( LIMIT_RANGE );
					found |= Check_Noise1_16();
				} while( found );
				break;


			// Noise detection only
			case 999:
				do
				{
					found = FALSE;



					// big -> small blocks
					found |= Check_Noise4_16( LIMIT_RANGE );
					found |= Check_Noise3_16( LIMIT_RANGE );
					found |= Check_Noise2_16( LIMIT_RANGE );
					found |= Check_Noise1_16();
				} while( found );
				break;
		}
	}
}
